/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.Locales;
import net.skinsrestorer.shadow.aikar.locales.MessageKey;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class CommandPropertiesManager {
    private static final String FILE = "command-messages.properties";

    public static void load(CommandManager<?, ?, ?, ?, ?, ?> manager, Path dataFolder, InputStream defaultConfigStream, SRLogger logger) {
        Path outFile = dataFolder.resolve(FILE);
        if (!Files.exists(outFile, new LinkOption[0])) {
            try {
                Files.copy(defaultConfigStream, outFile, new CopyOption[0]);
            }
            catch (IOException ex) {
                logger.warning("Could not save " + outFile.getFileName() + " to " + outFile);
                ex.printStackTrace();
            }
        }
        try {
            defaultConfigStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try (InputStream in = Files.newInputStream(outFile, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> manager.getLocales().addMessage(Locales.ENGLISH, MessageKey.of(k.toString()), C.c(v.toString()))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

